/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
/**
 *\file :  DM8127_types.h
 *
 *\brief:  Defines the statndard types for CCS sample code
 *
 *         This header file contains the standard typedefs and macros
 *         for use with CCS test code for DM8127 EVM.
 *
 *\author: Antriksh
 *
 *\Version: 01a,28Sep2016, An created.
 */

#ifndef _DM8127_types_H_
#define _DM8127_types_H_

#ifdef __cplusplus
 extern "C" {
#endif

/*
 *====================
 * Includes
 *====================
 */

/**
@addtogroup DM8127 Types
@{
*/

/*
 *====================
 * Defines
 *====================
 */

 #define INIT_VALUE           (0u)
 #define SUCCESS		      (0u)
 #define FAILED		          (-1)
 #define DM8127_INIT_VAL      (0x00)
 #define MANUFACTURE_INIT_VAL (0xFF)

 #define SW_BREAKPOINT        asm( " .long 0xe1200070" );

/*
 *====================
 * Typedefs
 *====================
 */

 /**< Alias name for the unsigned char>*/
typedef unsigned char 	UINT8;
/**< Alias name for the unsigned short int>*/
typedef unsigned short int	UINT16;
/**< Alias name for the unsigned int >*/
typedef unsigned int 	UINT32;
/**< Alias name for the signed char >*/
typedef signed char 	SINT8;
/**< Alias name for the signed short int  >*/
typedef signed short int	SINT16;
/**< Alias name for the signed int >*/
typedef signed int 	    SINT32;
/**< Alias name for the void >*/
typedef void            VOID;
/**< Alias name for the signed int >*/
typedef signed int 	        STATUS;
/**< Alias name for the volatile unsigned int >*/
typedef volatile unsigned int VUINT32;


#ifdef __cplusplus
} /* End of extern C */
#endif /* #ifdef __cplusplus */

#endif  /* End of _DM8127_types_H_ */
